/*
Standard vertex transform shader for skinned models.
Skin support with weights and joints.
Applies mirroring plane to user clip plane 0
*/
#version 430

//Standard vertex attributes, set to the default locations
layout(location = 0) in vec4 in_position;
layout(location = 6) in vec4 in_weight;
layout(location = 7) in uvec4 in_joint;

//Uniform block for global matrices
#pragma lz append("lzsystem/shaders/generic/globalTransforms.glsl")

//Skin
layout(std140, binding = 1) uniform skin {
	mat4 joint[256];
};

void main() {
	//Go through all weights to calculate the skin matrix
	mat4 wskin = mat4(0);
	for(int i=0; i<4; i++)
		wskin += in_weight[i] * joint[in_joint[i]];

	//The distance to the plane, to set the custom clip plane
	gl_ClipDistance[0] = dot((wskin * (model * in_position)).xyz,mirrorPlane.xyz) + mirrorPlane.w;

	gl_Position = pvm * wskin * in_position;

}
